<?php
/**
 * @version    1.0.0
 * @package    com_simplerecipe
 * @author     Simple Recipe <support@simplerecipe.cloud>
 * @copyright  2023 Simple Recipe
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Layout\LayoutHelper;
use \Joomla\CMS\Session\Session;
use \Joomla\CMS\User\UserFactoryInterface;

HTMLHelper::_('bootstrap.tooltip');
HTMLHelper::_('behavior.multiselect');
HTMLHelper::_('formbehavior.chosen', 'select');

$user       = Factory::getApplication()->getIdentity();
$userId     = $user->get('id');
$listOrder  = $this->state->get('list.ordering');
$listDirn   = $this->state->get('list.direction');
$canCreate  = $user->authorise('core.create', 'com_simplerecipe') && file_exists(JPATH_COMPONENT . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR . 'recipeform.xml');
$canEdit    = $user->authorise('core.edit', 'com_simplerecipe') && file_exists(JPATH_COMPONENT . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR . 'recipeform.xml');
$canCheckin = $user->authorise('core.manage', 'com_simplerecipe');
$canChange  = $user->authorise('core.edit.state', 'com_simplerecipe');
$canDelete  = $user->authorise('core.delete', 'com_simplerecipe');

// Import CSS
$wa = $this->document->getWebAssetManager();
$wa->useStyle('com_simplerecipe.list');
$document = JFactory::getDocument();
$document->addStyleSheet(JUri::root() . 'components/com_simplerecipe/assets/css/simplerecipe.css');
?>

    <form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post"
          name="adminForm" id="adminForm">
		<?php if (!empty($this->filterForm)) {
			echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this));
		} ?>
        <div class="table-responsive">
            <table class="table table-striped" id="recipeList">
                <thead>
                <tr>
                    <th class=''>
						<?php echo HTMLHelper::_('grid.sort', 'COM_SIMPLERECIPE_RECIPES_TITLE', 'a.title', $listDirn, $listOrder); ?>
                    </th>

                    <th class=''>
		                <?php echo HTMLHelper::_('grid.sort', 'COM_SIMPLERECIPE_RECIPES_CATID', 'a.catid', $listDirn, $listOrder); ?>
                    </th>

                    <th class=''>
						<?php echo HTMLHelper::_('grid.sort', 'COM_SIMPLERECIPE_RECIPES_FROM_KITCHEN', 'a.from_kitchen', $listDirn, $listOrder); ?>
                    </th>

                    <th class=''>
						<?php echo HTMLHelper::_('grid.sort', 'COM_SIMPLERECIPE_RECIPES_FAVORITE', 'a.favorite', $listDirn, $listOrder); ?>
                    </th>

                    <th class=''>
						<?php echo HTMLHelper::_('grid.sort', 'COM_SIMPLERECIPE_RECIPES_DIETARY', 'a.dietary', $listDirn, $listOrder); ?>
                    </th>

                    <th class=''>
		                <?php echo HTMLHelper::_('grid.sort', 'COM_SIMPLERECIPE_RECIPES_MODIFIED_BY', 'a.modified_by', $listDirn, $listOrder); ?>
                    </th>

                    <th class=''>
		                <?php echo HTMLHelper::_('grid.sort', 'COM_SIMPLERECIPE_RECIPES_HITS', 'a.hits', $listDirn, $listOrder); ?>
                    </th>

                    <?php if ($canEdit || $canDelete): ?>
                        <th class="center">
							<?php echo Text::_('COM_SIMPLERECIPE_RECIPES_ACTIONS'); ?>
                        </th>
					<?php endif; ?>

                </tr>
                </thead>
                <tfoot>
                <tr>
                    <td colspan="<?php echo isset($this->items[0]) ? count(get_object_vars($this->items[0])) : 10; ?>">
                        <div class="pagination">
							<?php echo $this->pagination->getPagesLinks(); ?>
                        </div>
                    </td>
                </tr>
                </tfoot>
                <tbody>
				<?php foreach ($this->items as $i => $item) : ?>
					<?php $canEdit = $user->authorise('core.edit', 'com_simplerecipe'); ?>

                    <tr class="row<?php echo $i % 2; ?>">

                        <td>
							<?php $canCheckin = Factory::getApplication()->getIdentity()->authorise('core.manage', 'com_simplerecipe.' . $item->id) || $item->checked_out == Factory::getApplication()->getIdentity()->id; ?>
							<?php if ($canCheckin && $item->checked_out > 0) : ?>
                                <a href="<?php echo Route::_('index.php?option=com_simplerecipe&task=recipe.checkin&id=' . $item->id . '&' . Session::getFormToken() . '=1'); ?>">
									<?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->uEditor, $item->checked_out_time, 'recipe.', false); ?></a>
							<?php endif; ?>
                            <a href="<?php echo Route::_('index.php?option=com_simplerecipe&view=recipe&id=' . (int) $item->id . '&catid=' . (int) $item->catid); ?>">
								<?php echo $this->escape($item->title); ?></a>
                        </td>
                        <td>
		                    <?php echo $item->catid_name; ?>
                        </td>
                        <td>
							<?php echo $item->from_kitchen; ?>
                        </td>
                        <td>
	                        <?php if ($item->favorite == 1) : ?>
                                <span class="icon-jcc fa-star" aria-hidden="true"></span>
	                        <?php endif ?>
                        </td>
                        <td>
							<?php echo $item->dietary; ?>
                        </td>
                        <td>
		                    <?php $container = \Joomla\CMS\Factory::getContainer();
		                    $userFactory     = $container->get(UserFactoryInterface::class); ?>
		                    <?php $user = $userFactory->loadUserById($item->modified_by); ?>
		                    <?php echo $user->name; ?>
                        </td>
                        <td>
		                    <?php echo $item->hits; ?>
                        </td>
						<?php if ($canEdit || $canDelete): ?>
                            <td class="center">
                            </td>
						<?php endif; ?>

                    </tr>
				<?php endforeach; ?>
                </tbody>
            </table>
        </div>
		<?php if ($canCreate) : ?>
            <a href="<?php echo Route::_('index.php?option=com_simplerecipe&task=recipeform.edit&id=0', false, 0); ?>"
               class="btn btn-success btn-small"><i
                        class="icon-plus"></i>
				<?php echo Text::_('COM_SIMPLERECIPE_ADD_ITEM'); ?></a>
		<?php endif; ?>

        <input type="hidden" name="task" value=""/>
        <input type="hidden" name="boxchecked" value="0"/>
        <input type="hidden" name="filter_order" value=""/>
        <input type="hidden" name="filter_order_Dir" value=""/>
		<?php echo HTMLHelper::_('form.token'); ?>
    </form>

<?php
if ($canDelete)
{
	$wa->addInlineScript("
			jQuery(document).ready(function () {
				jQuery('.delete-button').click(deleteItem);
			});

			function deleteItem() {

				if (!confirm(\"" . Text::_('COM_SIMPLERECIPE_DELETE_MESSAGE') . "\")) {
					return false;
				}
			}
		", [], [], ["jquery"]);
}
?>