<?php
/**
 * @version    1.0.0
 * @package    com_simplerecipe
 * @author     Simple Recipe <support@simplerecipe.cloud>
 * @copyright  2023 Simple Recipe
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Session\Session;
use Joomla\Utilities\ArrayHelper;

\Joomla\CMS\HTML\HTMLHelper::_('bootstrap.carousel', '.selector', []);
$document = JFactory::getDocument();
$document->addStyleSheet(JUri::root() . 'media/com_simplerecipe/css/simplerecipe.css');
?>

<?php //Get the total time for the entire process
$subform_parts = json_decode($this->item->parts);
$outer         = 1;
$totalSeconds  = 0;
foreach ($subform_parts as $part)
{
	$totalSeconds += $part->val * (int) ($part->dur);
}
$totalHours = (int)($totalSeconds / 3600);
$totalMinutes = ($totalSeconds - (int)($totalHours * 3600));
$totalMinutes /= 60;

?>

<div class="card text-center">
    <div class="card-header">
        <div class="container text-center">
            <div class="row">
                <div class="h1 col">
					<?php echo $this->item->title; ?>
					<?php if ($this->item->favorite == 1) : ?>
                        <span class="icon-jcc fa-star" aria-hidden="true"></span>
					<?php endif ?>
                </div>
            </div>
            <div class="row">
                <div class="col">
					<?php $plural = explode(",", ($this->item->catid)); ?>
					<?php if (count($plural) > 1) : ?>
						<?= Text::_('COM_SIMPLERECIPE_FORM_LBL_CATEGORIES') . ": " . $this->item->catid; ?>
					<?php else : ?>
						<?= Text::_('COM_SIMPLERECIPE_FORM_LBL_CATEGORY') . ": " . $this->item->catid; ?>
					<?php endif ?>
                </div>
                <div class="col">
					<?= Text::_('COM_SIMPLERECIPE_FORM_LBL_RECIPE_HITS') . ": " . $this->item->hits; ?>
                </div>
                <div class="col">
                    <?php if ($totalHours > 1) : ?>
					<?= Text::_('COM_SIMPLERECIPE_FORM_LBL_RECIPE_TIME') . ": " . $totalHours . "hours ". $totalMinutes . " minutes"; ?>
                    <?php else : ?>
                    <?= Text::_('COM_SIMPLERECIPE_FORM_LBL_RECIPE_TIME') . ": " . $totalMinutes . " minutes"; ?>
                    <?php endif ?>
                </div>
            </div>
            <div class="row">
                <div class="col" style="text-align: left;">
                    <?= Text::_('COM_SIMPLERECIPE_FORM_LBL_RECIPE_DIETARY') . ": " . $this->item->dietary; ?>
                </div>
            </div>
            <div class="row">
                <div class="col" style="text-align: left;">
					<?= $this->item->from_kitchen; ?>
                </div>
                <div class="col" style="text-align: right;">
					<?= $this->item->serve_instructions; ?>
                </div>
            </div>
        </div>
    </div>

	<?php //Get the array of photos for use in the carousel
	$picture  = json_decode($this->item->images);
	$photoarr = [];

	foreach ($picture as $pic => $pics)
	{
		$objectToArray = (array) $pics;
		$pieces        = explode("#", $objectToArray['image']);
		array_push($photoarr, $pieces[0]);
	}
	?>


    <div class="card-body">
        <div id="carouselOfFood" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-inner">
				<?php $photoindex = 0; ?>
				<?php foreach ($photoarr as $photo) : ?>
				<?php if ($photoindex == 0) : ?>
                <div class="carousel-item active" data-bs-interval="10000">
					<?php else : ?>
                    <div class="carousel-item" data-bs-interval="5000">
						<?php endif ?>
                        <img src="<?= $photoarr[$photoindex]; ?>" class="d-block w-100" alt="Simple Recipe Photo"
                             style="width: 800px; height: 600px; object-fit: cover;">
                    </div>
					<?php $photoindex++; ?>
					<?php endforeach ?>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#carouselOfFood"
                        data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carouselOfFood"
                        data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        </div>


        <ul class="list-group list-group-flush">
            <li class="list-group-item">
				<?php $subform_parts = json_decode($this->item->parts); ?>
				<?php $outer = 1; ?>
				<?php foreach ($subform_parts as $part) : ?>
                    <h3 class="text-start"> <?= $part->title ?> </h3>
					<?php $ingredientsList = explode("\r\n", $part->ingredients); ?>
                    <ul class="fields-container">
                        <div class="field-entry ingredients-<?= $outer ?> ingredients">
							<?php $index = 1; ?>
							<?php foreach ($ingredientsList as $ingredient) : ?>
                                <li><input type="checkbox" name="check"
                                           id="check-ingredients-<?= $outer ?>-<?= $index ?>"
                                           value="check-ingredients-<?= $outer ?>-<?= $index ?>"> <label itemprop="ingredients" for="check-ingredients-<?= $outer ?>-<?= $index ?>"> <p><?= $ingredient ?></p></label>
                                </li>
								<?php $index++; ?>
							<?php endforeach ?>
                        </div>
						<?php $outer++; ?>
                    </ul>
				<?php endforeach ?>
            </li>
        </ul>


        <ul class="list-group list-group-flush">
            <li class="list-group-item">
				<?php $array = ["First", "Second", "Third", "Fourth", "Fifth, Sixth, Seventh, Eighth, Ninth, Tenth"]; ?>
				<?php $outer = 1; ?>
				<?php foreach ($subform_parts as $part) : ?>
                <?php if ($part->directions != "") : ?>

	                    <?php if (isset($subform_parts->parts1)) : ?>
                            <h3 class="text-start"> <?= $array[$outer - 1] . " Part Directions" ?> </h3>
                        <?php else : ?>
                            <h3 class="text-start"> <?= "Directions" ?> </h3>
	                    <?php endif ?>

						<?php $directionList = explode("\r\n", $part->directions); ?>
                        <ul class="fields-container">
                            <div class="field-entry directions-<?= $outer ?> directions">
								<?php $index = 1; ?>
								<?php foreach ($directionList as $step) : ?>
                                    <li><input type="checkbox" autocomplete="off" name="check" id="check-directions-<?= $outer ?>-<?= $index ?>" value="check-directions-<?= $outer ?>-<?= $index ?>">
                                        <label itemprop="directions" for="check-directions-<?= $outer ?>-<?= $index ?>"><p><?= $step ?></p> </label>
                                    </li>
									<?php $index++; ?>
								<?php endforeach ?>
                            </div>
							<?php $outer++; ?>
                        </ul>
					<?php endif ?>
				<?php endforeach ?>
            </li>
        </ul>
        <div class="card-footer text-muted">
			<?php echo Text::_('COM_SIMPLERECIPE_FORM_LBL_RECIPE_CREATED_TIME') . ": " . JHTML::_('date', $this->item->created_time, "Y-m-d") . " | "; ?>
			<?php echo Text::_('COM_SIMPLERECIPE_FORM_LBL_RECIPE_MODIFIED_TIME') . ": " . JHTML::_('date', $this->item->modified_time, "Y-m-d"); ?>
        </div>
    </div>

