<?php
/**
 * @version    1.0.0
 * @package    com_simplerecipe
 * @author     Simple Recipe <support@simplerecipe.cloud>
 * @copyright  2023 Simple Recipe
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language\Text;

$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive')
	->useScript('form.validate');
HTMLHelper::_('bootstrap.tooltip');
?>

<form
        action="<?php echo Route::_('index.php?option=com_simplerecipe&layout=edit&id=' . (int) $this->item->id); ?>"
        method="post" enctype="multipart/form-data" name="adminForm" id="recipe-form"
        class="form-validate form-horizontal">


	<?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => 'recipe')); ?>
	<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'recipe', Text::_('COM_SIMPLERECIPE_TAB_RECIPE', true)); ?>
    <div class="row-fluid">
        <div class="span10 form-horizontal">
            <fieldset class="adminform">
                <legend><?php echo Text::_('COM_SIMPLERECIPE_FIELDSET_RECIPE'); ?></legend>
                <div class="container">
                    <div class="row">
                        <div class="col">
	                        <?php echo $this->form->renderField('title'); ?>
                        </div>
                        <div class="col">
	                        <?php echo $this->form->renderField('catid'); ?>
                        </div>
                    </div>
                </div>
				<?php echo $this->form->renderField('parts'); ?>
                <div class="container">
                    <div class="row">
                        <div class="col">
	                        <?php echo $this->form->renderField('favorite'); ?>
                        </div>
                        <div class="col">
	                        <?php echo $this->form->renderField('serves_number'); ?>
                        </div>
                        <div class="col">
		                    <?php echo $this->form->renderField('serve_instructions'); ?>
                        </div>
                        <div class="col">
	                        <?php echo $this->form->renderField('dietary'); ?>
                        </div>
                    </div>
                </div>
                <div class="container">
                    <div class="row">
                        <div class="col">
	                        <?php echo $this->form->renderField('created_time'); ?>
                        </div>
                        <div class="col">
	                        <?php echo $this->form->renderField('modified_time'); ?>
                        </div>
                        <div class="col">
	                        <?php echo $this->form->renderField('hits'); ?>
                        </div>
                    </div>
                </div>
	            <?php echo $this->form->renderField('images'); ?>
				<?php echo $this->form->renderField('from_kitchen'); ?>
				<?php if ($this->state->params->get('save_history', 1)) : ?>
                    <div class="control-group">
                        <div class="control-label"><?php echo $this->form->getLabel('version_note'); ?></div>
                        <div class="controls"><?php echo $this->form->getInput('version_note'); ?></div>
                    </div>
				<?php endif; ?>
            </fieldset>
        </div>
    </div>
	<?php echo HTMLHelper::_('uitab.endTab'); ?>
    <input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>"/>
    <input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>"/>
    <input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>"/>
    <input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>"/>
    <input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>"/>
	<?php echo $this->form->renderField('created_by'); ?>
	<?php echo $this->form->renderField('modified_by'); ?>


	<?php echo HTMLHelper::_('uitab.endTabSet'); ?>

    <input type="hidden" name="task" value=""/>
	<?php echo HTMLHelper::_('form.token'); ?>

</form>
